# Release notes for Subplot

This file summarises the changes between released versions of Subplot and its
associated libraries, especially with regards to changes visible to
the user of the Subplot software.

# Version 0.14.0, released 2025-12-19

Breaking changes:

* Per the deprecation warning in 0.13.0, we no longer publish the
  `subplot-build` crate. Please adapt per the migration information
  in the 0.13.0 news below.

Bug fixes:

* In the markdown parser, subscript and superscript are now supported
  and passed into HTML rather than being ignored.

New features:

* The `files` step library now has `given executable file ...` steps
  which create files with the executable bit set on platforms which
  require it.
* The `files` step library how has `given directory` as an alias for
  `given a directory`
* The `runcmd` step library now has `then command succeeds` as an alias
  for `then command is successful`.
* Steps internally have their scenario line numbering retained for use
  by docgen and codegen.
* Rendered scenarios now have line numbering.
* Rust scenarios can now report the scenario line number when steps
  fail, in case a step is repeated in a scenario.

# Version 0.13.0, released 2025-08-02

Deprecation changes:

* We are now officially deprecating `subplot-build` in favour of
  `subplotlib::codegen!()` - in later versions we will stop publishing
  `subplot-build`.

  To make this change, you should no longer use `subplot-build` at all,
  and instead in your `tests/foo.rs` files where you previously did
  `include!(...)` you should call `subplotlib::codegen!("foo.subplot")`
  instead. See the macro's documentation for acceptable argument forms.

Breaking changes:

* We have deleted the `bash` template.  If you have projects which
  used it then you can dig it out of our git repository and embed
  the template into your project.  However we strongly recommend that
  you translate your scenario suite into Python or Rust.

Bug fixes:

* The `Runcmd` scenario context object in the Rust step library has
  gained a `.with_forklock()` method which can be used to reduce the
  likelihood of flakiness introduced by threaded test suites and
  forking subprocesses to run scripts newly written out by scenarios.

* The error message for a step not being found in any bindings file
  now reports the location of the step.

* The `lib/files` step library now enforces that all filenames
  captured from the step text are relative to the data directory for
  the scenario execution.

* The Rust implementation of the `lib/runcmd` step library has been
  clarified that it runs commands in the scenario datadir, not the
  source tree.

* The Rust implementation of the `lib/runcmd` of the step "when I run,
  in {dir}, ..." no longer sets the `HOME` environment variable to
  `dir`.


New features:

* Scenarios can be labelled using a `label=foo` attribute in the
  first block of steps in a scenario.

* The `metadata` subcommand now provides information about scenario
  labels.  This changes the JSON format slightly.

* The `lib/runcmd` library now supports steps to set and unset
  environment variables.

* Subplot now has groundwork to support filtering scenarios. Actual
  filters will come later.

* The `lib/files` step library now had steps for removing files and
  empty directories.

* The `lib/files` step library now has steps to compare an on-disk
  file for equality with another on-disk file or an embedded file.

* The `lib/runcmd` step library now has a step "then I can run...",
  similar to "when I run...", but as a "then". This will make it more
  natural to use in some circumstances.

* The `lib/runcmd` step library now supports the standard input to be
  redirected.

Other changes:

* Name slugs (eg. test function names) now pass digits through, will
  automatically prefix with `n_` if the slug would otherwise start
  with a digit; and will suffix with `_NNN` where NNN is selected
  to make the name unique.  Ordering of scenarios is not guaranteed
  to remain stable, so it's always better to come up with unique
  names for scenarios rather than relying on this last feature.

* Subplot's build system uses pandoc to construct step library
  manuals.

* The `README.md` and other documentation is clearer and up to date on
  how to actually run Subplot and its test suite. The `./check` script
  has been replaced with `Makefile` for clarity.

* Various error messages have been clarified.


# Version 0.12.0, released 2024-12-24

* The binary has been moved to `subplot-bin` in order to reduce the
  dependency list in `subplot`.

* A new macro was added to `subplotlib` giving `subplotlib::codegen!()`
  currently very simple, but will gain functionality with newer
  releases.  This reduces/removes the need for `subplot-build` in many
  cases and may result in its deprecation in future.

* Additional ergonomics were added to the `#[step]` attribute macro
  to deal with cases where the body of the function does not parse.
  This should improve IDE diagnostics at least a little.

* New `--log-level` argument to the `subplot` binary is available to
  make it easier to select simple logging levels rather than having
  to use the `SUBPLOT_LOG` environment variable.

* Logging formatter changed slightly.  If you were relying on the
  exact format of log messages from the `subplot` tool then you may
  need to adjust your scripts.  For example, instead of `INFO: ` and
  `ERROR: ` you will find ` INFO ` and `ERROR ` at the start of lines.

* New capture types `escapedword` and `escapedtext` added which process
  backslash escapes inside Subplot during code generation.  Some bindings
  which previously did escape expansion in the step libraries have been
  updated to use this capture type instead.

# Version 0.11.0, released 2024-08-20

* We've fixed step parsing to only split a step into words at ASCII
  white spaces, instead of any Unicode white space character. This
  allows a scenario to match on any literal Unicode characters,
  without Subplot turning them to an ASCII space character.

* We now only self-close HTML tags that allow it, based on list at
  <https://www.scaler.com/topics/self-closing-tags-in-html/>.
  Specifically, `br`, `hr`, `img`, `link`, and `meta` tags are closed:
  `<br/>` instead of `<br></br>`. Previously we self-closed any
  element that was empty, but it turns out world wide web technology
  is more complicated than that.

* Errors using `subplot_build` from a project's `build.rs` are now
  more visible in `cargo` output.

* The HTML generated by `subplot docgen` now contains a more useful
  and easier to read table of contents. Headings are numbered also in
  the text, not just in the table of contents.

* We're using `cargo minimal-versions` so that when we depend on a
  crate, we can try to specify the minimal version that will work
  for us. This is meant to help packaging Subplot for Linux
  distributions, by not being so strict about requiring the latest
  version of everything.  Over time we will relax dependencies as we
  determine that they are safe to do so.

* We've updated Subplot's MSRV to 1.79 to permit wider dependency
  flexibility.

# Version 0.10.0, released 2024-06-15

It has been a long time since the previous release. Due to life and
work commitments, our work on Subplot has had to be put on a lower
priority. However, some things have happened.

* HTML output is now more technically correct HTML5 rather than just
  something that seems to render more or less OK in whatever browser
  Lars has handy. To start with, it's explicitly declared as HTML5 by
  the DOCTYPE. A number of fixes has been made to the HTML, and the
  test suite now verifies the correctness with the html-tidy tool.
  There is now a table of contents, and at least basic tables work.
  The CSS provided by Subplot has also been changed, and is now less
  of a prototype. (We'd love to have help making the output more
  readable, more accessible, and more stylish.)

* Subplot now requires bindings files to have documentation for each
  binding (overridden by `--merciful`), and warns if the name or type
  of a capture is missing. We generate documentation for the step
  libraries provided by Subplot, and publish it at
  <https://doc.subplot.tech/libdocs/>. Further, when a binding has an
  error, the error message now tells the user what file the binding
  came from.

* The fledgling "Subplot book" (in the `book` directory and published
  at <https://doc.subplot.tech/user-guide.html>) now defines the
  terminology we use to discuss "needs", "acceptance criteria", and
  "requirements".

Bug fixes:

* In the Rust implementation of the `lib/files` step library, when a
  file is overwritten, it is first truncated. Previously, we were only
  writing the new content over the beginning of the file, which could
  result in parts of the old content remaining at the end of the file.

Related to development of Subplot itself:

* We've re-enabled testing against chosen old versions of Subplot
  (specifically, 0.9.0) so that we are less likely to accidentally
  break backwards compatibility.

* We now require contributors to add a `Signed-off-by` footer in git
  commit messages to signal the commit meets the assertion for a
  Developer Certificate of Origin. See the the `DECISIONS.md` file in
  the source tree.

- We've update Subplot's minimum supported Rust version (MSRV) to 1.75
  in line with Debian testing a the time of the update.


# Version 0.9.0, released 2023-08-27

- We hope this will be the last breaking change before 1.0, however we
  are not ruling out future breaks if they are justified to improve
  usability or capability before an official 1.0 release
- We now pass a lot more meta-information about step location to the
  templates for building test suites.

# Version 0.8.0, released 2023-06-14

- Subplot now permits multiple markdown documents to be used in a single
  subplot document.
- Indented scenario statements, while permitted before, were never meant
  to be part of the spec, they are now considered an error in case we
  wish to use the semantics of indentation later.

# Version 0.7.1, released 2023-04-30

- Subplot now handles scenario titles with markup (such as bold face).
  This was broken in the changes to drop use of Pandoc for parsing.
- CI job using the MSRV version doesn't check source code formatting
  anymore.
- The dependency on the roadmap crate now depends on a version that
  doesn't require the `clap` crate at all anymore.

# Version 0.7.0, released 2023-04-10

- Subplot no longer uses `pandoc` at all. This means that
  output is currently limited to HTML only, and the formatting
  of that HTML has changed, however this is the first step
  along the path of being significantly easier to use long-term.
- Subplot's MSRV has been updated to 1.63 and our plan is to
  maintain an MSRV of whatever is in Debian's `testing` distribution
  until Subplot is in Debian.
- We have updated our crates to the 2021 edition of Rust. This should
  not affect anyone since the 2021 edition has been supported since
  1.56 of Rust.

# Version 0.6.0, released 2022-11-13

- Subplot metadata now expects `authors` rather than `author`
  to support multiple authors for documents. This is a breaking
  change, hence the semver bump.
- Subplot metadata now supports a `pandoc` mapping at the top level
  which provides metadata to be inserted into the Pandoc document
  build when producing PDFs or HTML.
- There is now a `path` type, to go alongside `text` `word` etc.
  Paths are expected to be (parts of) paths on the filesystem and
  we have updated all bindings to use `path` where sensible to do so.
- Subplotlib steps now handle the `path` type as `&Path`, so steps which
  expect to be given paths should use that, rather than `&str`.

# Version 0.5.0, released 2022-09-13

- The big, breaking change for this release is that Subplot now
  expects document metadata in a separate YAML file. It was previously
  embedded in the Markdown input file. This allows us to be more
  strict, when parsing the metadata: we only need to support what
  Subplot needs, not the nearly arbitrary YAML Pandoc supports. Later
  on, it will also enable us to support multiple Markdown files as
  input.

- That change also means that we drop support for use of Subplot as a
  Pandoc filter (the `subplot-filter` command and the `subplot filter`
  subcommand). It doesn't make sense unless the metadata is
  embedded in the Markdown.

- We've renamed things so that we consistently call a Markdown fenced
  code block that is marked as a data file, an "embedded file".
  Previously we also used other names, causing unnecessary confusion.

- The new home page URL is updated in all crate metadata. This means
  crates.io will point at the new location after this release is made.

# Version 0.4.3, released 2022-007-29

- Bump the dependency on the `roadmap` crate to a version that depends
  on `clap` version 3 to that it doesn't drag in `structopt`.

# Version 0.4.2, released 2022-007-28

- New feature: Subplot now supports example blocks: embedded files
  that are in the subplot document only as examples, not for use by
  scenarios.

- Subplot error messages are now a little bit more specific as to the
  cause, and what operation failed.

- Subplot now uses the `time` crate instead of the `chrono` crate to
  avoid a potential security issue.

- Terminology change: we now refer to diagrams as diagrams, not
  graphs.

# Version 0.4.1 (subplotlib only), released 2022-04-17

- Fix issue where subplotlib cannot be built out-of-tree

# Version 0.4.0, released 2022-04-16

- The largest change from the previous release is that Rust based
  subplot scenario test suites are now considered supported.
  You can find an example of this in the `examples/seq` project in
  the Subplot source code.

- To achieve this, bindings are now "polyglot" in the sense that they
  are not language specific, though some bindings may only provide
  implementations for particular languages (e.g. the daemon bindings
  currently only support Python)

- Subplot considers Rust 1.48.0 to be its MSRV. This is to enable
  integration into certain distributions and to work with other projects
  whose MSRVs are around that value.

- A number of quality of life improvements around warning delivery,
  template handling, etc. have been made. For the full details, see
  the Git changelog.

# Version 0.3.1, released 2021-11-16

- The primary purpose of this release is to make the `PATH` bug fix
  available via crates.io, to fix use of Subplot in the Sequoia-PGP
  project. There are no breaking changes, so only the patch level of
  the version number is incremented.

- The licence of Subplot has been changed to
  [MIT-0](https://mit-license.org/), to make it as simple as possible
  to use Subplot on other projects, without having to worry about
  license compatibility. Previously, this was technically possible,
  but the Subplot licence situation was complex enough that it caused
  people ask questions.

  The Subplot developers prefer, for Subplot, to maximize adoption and
  though they would favor a copyleft licence otherwise, they're
  willing to compromise this time.

- A bug has been fixed in the Rust `lib/runcmd` function
  implementation to prepend a directory to the `PATH`, in the
  `subplotlib::steplibrary::runcmd::try_to_run_in` function. The bug
  meant that the directories in `PATH` ended up in the wrong order.

# Version 0.3.0, released 2021-10-20

This is still an ALPHA quality release, and includes breaking changes.

## Breaking changes

You definitely need to pay attention to these changes.

- Subplot is moving to libraries and subplots being able to support
  multiple step implementation languages at once. In this release,
  bindings can indicate different functions for each language. Note
  that a binding only needs to support one language. The new binding
  format is:

```yaml
- given: foo
  impl:
    python:
      function: foo
      cleanup: foo_cleanup
    rust:
      function: somelib::foo
      cleanup: somelib::foo_cleanup
```

- The Subplot code generator now uses the `pulldown-cmark` crate for
  parsing Markdown input. The reason for this change is to not have to
  have Pandoc installed in a CI or other environment that only
  generates and runs test programs.

  The document generator still uses Pandoc for this, but it, too, will
  migrate to `pulldown-cmark` so that all parsing is done in the same
  way.

  The parsing crate should support the same Markdown variants as
  Pandoc does, more or less.

  Unfortunately, the YAML document metadata block is less forgiving
  now. The new metadata parser doesn't accept everything Pandoc does,
  and there will be a need to change input documents. The next release
  of Subplot is likely to introduce further changes, and we will
  document the new metadata format then.

- The generated test programs no longer clear the environment
  variables before running scenarios. This is partly to allow Subplot
  to be more easily ported to operating systems other than Debian
  (such as NixOS, but also Windows and macOS), but also because
  clearing the environment variables is not a good way to make sure
  the tests run in a known environment. Subplot now makes it the
  responsibility of the person running the test program to control
  where it is run: what software is installed, what services are
  available, etc.

- Subplot code generation now refuses documents that have no
  scenarios. Document generation still accepts them so that Subplot
  can be used to produce typeset documents and web pages.

## General

The changes in this section should not break any existing Subplot
documents. They affect all uses of Subplot, regardless of step
implementation language and whether Subplot code or document
generation is used.

- After a bug fix, Subplot now handles better the input files being
  elsewhere than the current directory. If the Markdown input file is
  in `foo/bar/yo.md`, the files referred to from the input file are
  looked up relative to `foo/bar` instead of the current working
  directory.

- Subplot now has initial support for logging to make it easier to
  find out what it's doing, when it's doing something surprising. The
  environment variables `SUBPLOT_LOG`, `SUBPLOT_LOG_FILE`, and
  `SUBPLOT_LOG_FORMAT` (`oneline`, `json`, or `pretty`). What Subplot
  logs is still rudimentary but will be improved over time. We'd
  welcome suggestions.

- The Subplot Debian package now builds in the resource into the
  Subplot binary.

- Document titles can now use markup to indicate `literal` text.

- Subplot now automatically handles versions of Pandoc that don't have
  a separate `pandoc-citeproc` binary, and want the `--citeproc`
  option instead.

- Subplot now works with version 1.48.0 of the Rust language and
  toolchain, in order to make it possible for the Sequoia-PGP project
  to use Subplot.

## Python support

- The generated Python test program now supports the `--run-all`
  (`-k`) option to run all scenarios even if one or more fail.

## Rust support

- Subplot now provides the `subplot-build` crate, for using Subplot
  code generation from another project's `build.rs` script.

- We are in the process of elevating Rust into a supported language,
  so that it will be on par with Python. This release does not get
  there, but starts the process.

## Bash support

- We've not made much effort to improve the Bash support (modulo the
  environment cleanup). Compared to Python and Rust it is not a
  well-support language in Subplot. Lars and Daniel do not feel it is
  a target worth spending much of their free time on, but would
  welcome help with that.

# Version 0.2.2, released 2021-08-07

This is release is meant for use by people other than Subplot's own
developers. It is of ALPHA quality, in that what is implemented is
meant to work, but we reserve the right to make backwards incompatible,
breaking changes in future releases.

## General

- When a scenario step matches more than one binding, the error
  message now lists all the matching bindings to make it easier for
  the user to fix the problem. (By Lars Wirzenius)

- The documentation now explains core concepts relevant to Subplot,
  and suggests an initial workflow for a project using Subplot. (By
  Lars Wirzenius)

## Python support

- The `lib/daemon` Subplot library now uses custom Python code instead
  of the netcat tool. This removes a dependency, and also avoids the
  problem of there being at least two more or less incompatible
  versions of netcat in common use. (By Alexander Batischev)

- The `lib/daemon` library now has a way to pass environment variables
  to the daemon. (By Alexander Batischev)

## Bash support

- The documentation now makes it clearer that the `files_get`
  function returns the contents of the embedded file and not a
  filename. (By Richard Maw)

- Some spelling and other language mistakes have been fixed in the
  documentation for Bash support. (By Richard Maw)

- The `dict` helper functions can now read embedded files. (By Richard
  Maw)

- The generated Bash test program now supports the `--env` option to
  let the user pass in environment variables when invoking the test
  program. (By Richard Maw)

- Assertion functions now return an error rather then terminating the
  test program. This lets cleanups run. (By Richard Maw)

# Version 0.2.1, released 2021-07-11

This is the first release meant for use by people other than Subplot's
own developers.

- The locations of the `dot` and `plantuml` programs and for the Java
  byte code interpreter can now be configured when Subplot is invoked,
  which is useful when they're not installed in the locations where
  Debian puts them. Those programs are used by Subplot to render
  diagrams.

- The `./check` script now outputs the last one hundred lines or so of
  the log file produced by the generated test program, if that program
  fails. This makes it easier to debug failures under CI.

- Additionally, there have been some minor tweaks only visible to
  those developing Subplot itself.

# Version 0.2.0, released 2021-06-12

This is the first public release of Subplot. No APIs or other surfaces are to be
considered stable at this time. While the `subplotlib` and `subplotlib-derive`
crates have been published, they do not form part of this release.

The only _template_ which is considered in any sense "supported" in this release
is the `python` template.
